/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __SPECIFIC_HEADER_INCLUDED__
#define __SPECIFIC_HEADER_INCLUDED__

#include "../../cpc/cpcglob.h"
#include "../../cpc/host.h"

struct GRAPHICS_BUFFER_INFO
{
	unsigned char *pSurface;		/* pointer to top-left for rendering */
	int			Width;				/* width of graphics image */
	int			Height;				/* height of graphics image */
	int			Pitch;				/* number of bytes in one line of graphics buffer including padding. */
};

GRAPHICS_BUFFER_INFO	*Host_GetGraphicsBufferInfo(void);
	

#if 0
typedef struct
{
	int BPP;						/* bits per colour */
	int Mask;						/* mask */
	int Shift;						/* shift */
} GRAPHICS_BUFFER_COLOUR_ELEMENT;

typedef struct
{
	int BPP;								/* bits per pixel (when R,G,B are combined) */
	GRAPHICS_BUFFER_COLOUR_ELEMENT Red;		/* information about red */
	GRAPHICS_BUFFER_COLOUR_ELEMENT Green;	/* information about green */
	GRAPHICS_BUFFER_COLOUR_ELEMENT Blue;	/* information about blue */
} GRAPHICS_BUFFER_COLOUR_FORMAT;

typedef struct
{
	int NumberOfChannels;	
	int BitsPerSample;
	int Frequency;
} SOUND_PLAYBACK_FORMAT;			
#endif

#if 0
struct GRAPHICS_BUFFER_COLOUR_FORMAT
{
	int BPP;								/* bits per pixel (when R,G,B are combined) */
	GRAPHICS_BUFFER_COLOUR_ELEMENT Red;		/* information about red */
	GRAPHICS_BUFFER_COLOUR_ELEMENT Green;	/* information about green */
	GRAPHICS_BUFFER_COLOUR_ELEMENT Blue;	/* information about blue */
};
#endif



/* windowed display, bit depth is dependant on window manager settings */
#define DISPLAY_TYPE_WINDOWED	0x0001
/* full-screen display, bit depth can be set independently of window manager settings */
#define DISPLAY_TYPE_FULLSCREEN	0x0002


BOOL	Host_LockGraphicsBuffer(void);	

void	Host_UnlockGraphicsBuffer(void);
void	Host_SwapGraphicsBuffers(void);
void	Host_SetPaletteEntry(int, unsigned char, unsigned char, unsigned char);
BOOL	Host_SetDisplay(int Type, int Width, int Height, int Depth);
struct GRAPHICS_BUFFER_COLOUR_FORMAT *Host_GetGraphicsBufferColourFormat(void);
void	Host_WriteDataToSoundBuffer(unsigned char *pData, unsigned long Length);
BOOL	Host_AudioPlaybackPossible(void);
SOUND_PLAYBACK_FORMAT *Host_GetSoundPlaybackFormat(void);
BOOL	Host_ProcessSystemEvents(void);
//void	Host_DoDriveLEDIndicator(int Drive, BOOL State);
//BOOL	Host_SaveFile(char *Filename, unsigned char *, unsigned long);
//BOOL	Host_LoadFile(char *Filename, unsigned char **pLocation, unsigned long *pLength);


unsigned long	Host_GetCurrentTimeInMilliseconds(void);

void Host_ClearAudioBuffer(void);
void Host_Throttle(void);

void DrawDisplay(void);

//speed - timing
void ResetTiming(void);
void UpdateTiming(unsigned long Diff);
int GetAverageSpeed(void);
void CountFps(void);

BOOL Render_SetDisplayWindowed(int Width = 0, int Height = 0);
int	Render_SetDisplayFullScreen(int, int,int);

//sound
BOOL Host_LockAudioBuffer(unsigned char **ppBuffer, unsigned long *pBuf1Size, unsigned char **ppBuffer2, unsigned long *pBuf2Size, unsigned long BuffSize);
void Host_UnLockAudioBuffer(void);


#endif